* Retraitement base fiscale 1998

set more off
clear

global year=1998

******************************************************************************************************************
* Legislative parameters converted in macro
		import excel using "$datarev/Parametres_IR.xls", first clear sheet("Parametres")  cellrange(A1:F27)
			foreach var of varlist tauxmicro_fon-tauxbnc{
				quiet sum `var' if year==$year
				global `var'=r(mean)
		}		
***************************************************************************************************************



use "$datarev/rev$year.dta",clear
foreach var of varlist _all {
	local j=upper("`var'")
	rename `var' `j'
}
gen year=$year
*drop ci-tr trib trin P2-clespi NTR1-codiliad ze-eirest mnirka-indquo indefba-COIRI9 defbaant-BTKIR96 mcirga-AGEN05


* Ponderation
	gen pondn=P

* Caractristiques dmographiques
	* age
		gen age=year-AGED
		replace age=20 if age <20 | age==.
	* Nombre de dclarants dans la dclaration
		gen ndecl=2
		replace ndecl=1 if AGEC==9999
	* age du conjoint
		gen agec=year-AGEC if AGEC~=999
		replace agec=20 if agec<20
	* sexe
		gen sexe=1 if CNFIP=="3"
		replace sexe=2 if CNFIP=="4"	
		
		
	* Structure demo des pac : 1998  2005
		local varlist = "AGEF01 AGEF02 AGEF03 AGEF04 AGEF05 AGEF06 AGEF07 AGEF08 AGEF09 AGEF10 AGEF11 AGEF12 AGER01 AGER02 AGER03 AGER04 AGER05 AGEJ01 AGEJ02 AGEJ03 AGEJ04 AGEJ05 AGEN01 AGEN02 AGEN03 AGEN04 AGEN05"
		gen npac =0
		local i=0
		foreach var in `varlist'{
			local i=`i'+1
			local k=`i'-1
			gen compteur`i'=`var' if (`var' >0 & !missing(`var') )
			if `i'==1 {
				gen position`i' =0
				replace position`i'=1 if (`var' >0 & !missing(`var') )
			}
			if `i'>1 {
				gen position`i' =position`k'
				replace position`i' =position`k'+1 if (`var' >0 & !missing(`var') )
			}
			replace npac=npac+1 if (`var' >0 & !missing(`var') )
		}
		
		forval pas=1/`i' {
			dis `pas'
			gen anaispac_`pas'= .
			quiet forval pasbis=1/`pas' {
				replace anaispac_`pasbis' = compteur`pas' if position`pas'==`pasbis' & compteur`pas'~=.
			}
		}
		drop position* compteur*
		quiet sum npac
		local min=r(max)+1
		forval drop=`min'/`i' {
			drop anaispac_`drop'
		}
		/* verif
			quiet sum npac
			dis r(max)
			forval a=1/`r(max)' {
				sum anaispac_`a'
			}

		*/
		* Retraitement de l'anne de naissance vers age
			quiet sum npac
			forval a=1/`r(max)' {
				* Naissance arriv aprs l'anne de dclaration
					replace anaispac_`a'=year if anaispac_`a'~=. & anaispac_`a'>year
				* Il manque le 19 dans 19xx
				replace anaispac_`a'=anaispac_`a'+1900 if anaispac_`a'~=. & anaispac_`a'<100 & year-anaispac_`a'<2000
				* Il manque le 20 dans 20xx
				replace anaispac_`a'=anaispac_`a'+2000 if anaispac_`a'~=. & anaispac_`a'<100 & year-anaispac_`a'>=2000
				* Il manque le 1 dans 9xx
				replace anaispac_`a'=anaispac_`a'+1000 if anaispac_`a'~=. & anaispac_`a'<1000 & anaispac_`a'>800
				* Il manque le 9 dans 1xx
				replace anaispac_`a'=anaispac_`a'+1800 if anaispac_`a'~=. & anaispac_`a'<800 & anaispac_`a'>100
				replace anaispac_`a'=year-anaispac_`a' if anaispac_`a'~=. 
			}

	* situation matrimoniale : 
		* Code: 1= mari (M) ; 2 = clibataire (C), 3: Divorc (D),4: veuf (V), 6:pacs (O)
		* Avant 2002, le pacs n'existait pas
		gen mat="M" if MAT==1
		replace mat="C" if MAT==2
		replace mat="D" if MAT==3
		replace mat="V" if MAT==4
		
		

	* Impot pay
		gen irtot=INE /* Impot net */
		gen irpv=IPP /* impot pv taux propor */
		gen iravantpv=irtot-irpv

	* Note: Attention: la base inclut les variables de la dclaration complmentaire et de la dclaration normale.

***********************************************************
*I)Traitements, salaires, pensions et rentes viagres  
***********************************************************
	
	foreach var of newlist sal_irpp chom_irpp frais_prof pension_irpp {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}

	* A) Salaires et chmages
	*************************
		* Pas de distinction entre sal et chom : on met tout dans sal et on utilisera seulement salchom
		replace sal_irpp=Z1AJ 
		replace chom_irpp=0

		replace sal_irpp_conj =  Z1BJ 
		replace chom_irpp_conj =0 
		
		* Frais pro
		replace frais_prof=Z1AK
		replace frais_prof_conj=Z1BK

	* B) Retraite
	**************
		* Inclue galement pensions alimentaires reues. Plus le cas  partir de 1999.
			replace pension_irpp=Z1AS
			replace pension_irpp_conj=Z1BS
			
	* C) Rentes viageres 
	**********************
		gen rente_irpp_foy=0
		local liste  A B C D 
		foreach x of local liste {
				local liste2 U W Y
				foreach y of local liste2 {
					replace rente_irpp_foy= rente_irpp_foy+Z1`x'`y'
				}
		}

	* D)Personne  charge PAC
	****************************
		* Suppression de la case RS et TS renomms ES et FS
		local liste C D E F
		foreach x of local liste {
			replace sal_irpp_pac= sal_irpp_pac + Z1`x'J  
			replace chom_irpp_pac= 0 
			replace frais_prof_pac=frais_prof_pac + Z1`x'K
			replace pension_irpp_pac= pension_irpp_pac+Z1`x'S
		}

		
	* E) Au niveau foyer fiscal
	****************************
		gen sal_irpp_foy=sal_irpp+sal_irpp_conj+sal_irpp_pac
		gen chom_irpp_foy=chom_irpp+chom_irpp_conj+chom_irpp_pac
		gen frais_prof_foy=frais_prof+frais_prof_conj+frais_prof_pac
		gen pension_irpp_foy =pension_irpp+ pension_irpp_conj +pension_irpp_pac
		gen salchom_irpp_foy=sal_irpp_foy+ chom_irpp_foy
		drop Z1A* Z1B* Z1C* Z1D* Z1E* Z1F*
	
	* Verif : 
		* agregat sal correspond  mon salchom_irpp_foy
		* agregat pen correspond  mon pens_irpp_foy
		* agregat rvto correspond  mon rente_irpp_foy

**************************************	
*II)  Revenus des capitaux mobiliers
**************************************	
		*Par rapport  1997:
		* LZ renomm EZ (Revenus valeurs mobilires et distri)
		* ML renomm FU et deplac dans la complmentaire(revenus imposables des actions et parts non cts dtenues dans un PEA) 
		* Ajout de dclarations des revenus d'avie (CH et DH)
		
		* A)Assurance-vie
		******************
			* Barme
				gen rfin_av_bar_irpp_foy = Z2CH
			* PL
				gen rfin_av_pl_irpp_foy= Z2DH
			* Total
				gen rfin_av_irpp_foy=rfin_av_bar_irpp_foy+rfin_av_pl_irpp_foy
		
		* B)Dividendes : 
		*****************
			* Au bareme 
				gen rfin_div_bar_irpp_foy = Z2DC +Z2FU
				gen rfin_div_bar_irpp_foy2 = Z2DC + Z2EZ*((10546284259-1385428895)/10546284259) +Z2FU
			* Au PL a partir de 2008
				gen rfin_div_pl_irpp_foy=0
			* Total
				gen rfin_div_irpp_foy=rfin_div_pl_irpp_foy+rfin_div_bar_irpp_foy
				gen rfin_div_irpp_foy2=rfin_div_pl_irpp_foy+rfin_div_bar_irpp_foy2
		
			
		* C)Interets 
		**************
			* Bareme
				gen rfin_int_bar_irpp_foy= Z2GR + Z2EZ+ Z2TR
				gen rfin_int_bar_irpp_foy2 = Z2GR + Z2EZ*(1385428895/10546284259)+ Z2TR
			* PL reporte seulement a partir de 2002
				gen rfin_int_pl_irpp_foy= 0
			* Total
				gen rfin_int_irpp_foy= rfin_int_bar_irpp_foy+ rfin_int_pl_irpp_foy
				gen rfin_int_irpp_foy2= rfin_int_bar_irpp_foy2+ rfin_int_pl_irpp_foy
		
		* D) Totaux 
		**************
				gen rfin_pl_irpp_foy=rfin_av_pl_irpp_foy+rfin_div_pl_irpp_foy+rfin_int_pl_irpp_foy
				gen rfin_bar_irpp_foy=rfin_av_bar_irpp_foy+rfin_div_bar_irpp_foy+rfin_int_bar_irpp_foy
				gen rfin_irpp_foy=rfin_av_irpp_foy+rfin_div_irpp_foy+rfin_int_irpp_foy

			* Avant 2005, on remboursait l'IS prlev sur les dividendes via un avoir fiscal pour viter double imposition.
			* Systme a chang en 2005 en crant un abattement remplaant l'avoir fiscal
			drop Z2*	

*******************************
*III) Revenus non salaris
*******************************
		* Changement complet du nom des variables par rapport  1997

	foreach var of newlist nonsal_irpp nonsalexo_irpp nonsal defnonsal_irpp microbic_vente microbic_serv microbnc {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}
		
		* A) Revenus non salaris exos
		*******************************
			local liste H K 
			foreach x of local liste {
				local liste2 N R B H
				foreach y of local liste2 {
					replace nonsalexo_irpp=nonsalexo_irpp+Z5`x'`y'
				}
			}
			
			local liste I L 
			foreach x of local liste {
				local liste2 N R B H
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5`x'`y'
				}
			}			
			
			
			local liste J M
			foreach x of local liste {
				local liste2 N R B H
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5`x'`y'
				}
			}
			
			
			
			local liste N Q
			foreach x of local liste {
				local liste2 B H
				foreach y of local liste2 {
					replace nonsalexo_irpp=nonsalexo_irpp+Z5`x'`y'		
				}
			}
			
			local liste O R 
			foreach x of local liste {
				local liste2 B H
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5`x'`y'		
				}
			}
			
			local liste P S
			foreach x of local liste {
				local liste2 B H
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5`x'`y'		
				}
			}
			
			
		* B)Revenus non salaris: benefice
		**************************************
				* On rajoute 25% pour centre non agr
								
				local liste H 
				foreach x of local liste {
					local liste2 O P Q 
					foreach y of local liste2 {
						replace nonsal_irpp=nonsal_irpp+Z5`x'`y'
					}
				}
							
				local liste I 
				foreach x of local liste {
					local liste2 O P Q 
					foreach y of local liste2 {
						replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'
					}
				}
								
				local liste J 
				foreach x of local liste {
					local liste2 O P Q 
					foreach y of local liste2 {
						replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'
					}
				}
				
				local liste H K N  
				foreach x of local liste {
					local liste2 C D
					foreach y of local liste2 {
						replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25 if Z5`x'A==0
						replace nonsal_irpp=nonsal_irpp+Z5`x'`y' if Z5`x'A==1
					}
					local liste2 I J
					foreach y of local liste2 {
						replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25
					}
				}
			
				local liste I L O
				foreach x of local liste {
					local liste2 C D
					foreach y of local liste2 {
						replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25 if Z5`x'A==0
						replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y' if Z5`x'A==1
					}
					local liste2 I J
					foreach y of local liste2 {
						replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25
					}
				}
			
				local liste J M P
				foreach x of local liste {
					local liste2 C D
					foreach y of local liste2 {
						replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25 if Z5`x'A==0
						replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y' if Z5`x'A==1
					}
					local liste2 I J
					foreach y of local liste2 {
						replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25
					}
				}
			
				local liste Q 
				foreach x of local liste {
					local liste2 C  
					foreach y of local liste2 {
						replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25 if Z5`x'A==0
						replace nonsal_irpp=nonsal_irpp+Z5`x'`y' if Z5`x'A==1
					}
					local liste2 I 
					foreach y of local liste2 {
						replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25 
					}
				}
				
				local liste R
				foreach x of local liste {
					local liste2 C  
					foreach y of local liste2 {
						replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25 if Z5`x'A==0
						replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y' if Z5`x'A==1
					}
					local liste2 I 
					foreach y of local liste2 {
						replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25 
					}
				}
				
				local liste S
				foreach x of local liste {
					local liste2 C  
					foreach y of local liste2 {
						replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25 if Z5`x'A==0
						replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y' if Z5`x'A==1
					}
					local liste2 I 
					foreach y of local liste2 {
						replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25 
					}
				}
				
				replace nonsal_irpp=nonsal_irpp+Z5SR+Z5SN if ndecl==1
				replace nonsal_irpp=nonsal_irpp+0.5*Z5SR+0.5*Z5SN if ndecl==2
				replace nonsal_irpp_conj=nonsal_irpp_conj+0.5*Z5SR+0.5*Z5SN if ndecl==2
				
		* C) Revenus non salairs: plus-values voir section plus-value rfin_pv_pro_irpp_foy
		***************************************************************************************	

		* D)Revenus non salaris: dficits
		***********************************
			local liste H 
			foreach x of local liste {
				local liste2 F L
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste I
			foreach x of local liste {
				local liste2 F L
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}
			local liste J
			foreach x of local liste {
				local liste2 F L
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}
			
			local liste K N
			foreach x of local liste {
				local liste2 F G L M
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste L O
			foreach x of local liste {
				local liste2 F G L M
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}			
			local liste M P
			foreach x of local liste {
				local liste2 F G L M
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}
			
			local liste Q 
			foreach x of local liste {
				local liste2 E K
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste R
			foreach x of local liste {
				local liste2 E K
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}			
			local liste S
			foreach x of local liste {
				local liste2 E K
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}
			replace defnonsal_irpp=defnonsal_irpp+Z5SP if ndecl==1			
			replace defnonsal_irpp=defnonsal_irpp+Z5SP/2 if ndecl==2
			replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5SP/2 if ndecl==2

	
		* E)Revenus non salaris: micro-fonciers et auto-entrepreneurs
		*************************************************************	
		* Recalcul du bnfice pour les auto-entrepreneurs et le rgime micro-entreprise (il faut dduire un abattement du chiffre d'affaire dclar pour retrouver le bnfice rel)
		* Les activits accessoires (tourisme et travaux forestiers) beneficient d'un abattement de 50% de 1996  1998 (checker avant). On les considre donc comme des micro bic (meme abattement)
			
			* Micro bic et autoentrepeneur : vente de marchandises
				* Avant 1999, pas de distinction entre BIC ventes de march et prest de services pour l'abattement
				local liste K
				foreach x of local liste {
					local liste2 O P Q
					foreach y of local liste2 {
						replace microbic_vente=microbic_vente+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste L  
				foreach x of local liste {
					local liste2 O P Q
					foreach y of local liste2 {
						replace microbic_vente_conj=microbic_vente_conj+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}				
				local liste M 
				foreach x of local liste {
					local liste2 O P Q
					foreach y of local liste2 {
						replace microbic_vente_pac=microbic_vente_pac+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}				
				
				
				local liste H
				foreach x of local liste {
					local liste2 S
					foreach y of local liste2 {
						replace microbic_vente=microbic_vente+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste I 
				foreach x of local liste {
					local liste2 S
					foreach y of local liste2 {
						replace microbic_vente_conj=microbic_vente_conj+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste J
				foreach x of local liste {
					local liste2 S
					foreach y of local liste2 {
						replace microbic_vente_pac=microbic_vente_pac+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
			* Micro bic et autoentrepeneur : 
				* Inclus dans microbic_vente avant 1999
				
			* Micro bnc et autoentrepeneur bnc
				local liste  K 
				foreach x of local liste {
					local liste2 S
					foreach y of local liste2 {
						replace microbnc=microbnc+Z5`x'`y' * (1-$tauxbnc)
					}
				}		
			    local liste  L 
				foreach x of local liste {
					local liste2 S
					foreach y of local liste2 {
						replace microbnc_conj=microbnc_conj+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				local liste  M
				foreach x of local liste {
					local liste2 S
					foreach y of local liste2 {
						replace microbnc_pac=microbnc_pac+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				
						
			foreach var of varlist nonsal_irpp {
				replace `var'=`var'+microbnc+ microbic_serv+microbic_vente
				replace `var'_conj=`var'_conj+microbnc_conj+ microbic_serv_conj+microbic_vente_conj
				replace `var'_pac=`var'_pac+microbnc_pac+ microbic_serv_pac+microbic_vente_pac
			}
			foreach var of varlist nonsal {
				replace `var'=`var'_irpp+`var'exo_irpp
				replace `var'_conj=`var'_irpp_conj+`var'exo_irpp_conj
				replace `var'_pac=`var'_irpp_pac+`var'exo_irpp_pac
			}

							
			gen nonsal_irpp_foy=nonsal_irpp+nonsal_irpp_conj+nonsal_irpp_pac
			gen nonsalexo_irpp_foy=nonsalexo_irpp+nonsalexo_irpp_conj+nonsalexo_irpp_pac
			gen nonsal_foy=nonsal_irpp_foy+nonsalexo_irpp_foy
			
			
************************			
*IV)  Revenus fonciers
************************
		* Changement de nom des variables: on passe de CD-CH  BA-BE
		
		* A)Regime normal net de charges et intrts
		********************************************
			*en cas de benefices
				gen rfon_normal_irpp_foy=Z4BA
			* en cas de deficits: deficts catgoriels ou global
				gen rfon_defcat_foy= Z4BB
				gen rfon_defglo_foy=Z4BC
				
		* B) Regime micro-foncier brut
		******************************
			gen rfon_micro_irpp_foy= Z4BE *${tauxmicro_fon}
		
		gen rfon_irpp_foy=rfon_normal_irpp_foy+rfon_micro_irpp_foy
		* Note : variable rfb correspond  rfon_irpp_foy=rfon_normal_irpp_foy+(1-abt)* rfon_micro_irpp_foy
		drop Z4*

*****************
* V) Plus value	*	
*****************

		gen rfin_pv_pro_irpp_foy=0
		gen rfin_mv_pro_irpp_foy=0
		gen rfin_pv_fon_irpp_foy=0
		gen rfin_pv_fin_irpp_foy=0
		gen rfin_mv_fin_irpp_foy=0
		gen rfin_pv_options_foy=0
		
		* Changement de nom des variables par rapport  1997
		
		*A) Plus-values professionnelles
		********************************
		
			* Plus values
			
				replace rfin_pv_pro_irpp_foy=Z3VD /* Cession socit soumise  l'IR*/
			
				local liste H I J K L M N O P
				foreach x of local liste {
					local liste2 E K
					foreach y of local liste2 {
						replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
					}
				}
				local liste  Q R S
				foreach x of local liste {
					local liste2 D J
					foreach y of local liste2 {
						replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
					
					}
				}
				replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5SS+Z5SO
				drop Z5*
				
		* B) Plus-values foncires	
		***************************
			* VD-VF renomm en VA-VC
			replace rfin_pv_fon_irpp_foy=Z3VA + Z3VB + Z3VC
	
		*C) Plus-values financires
		***************************
		
			* Regime normal + pv de PEA clotur avant 2 ans + pv capital risque 
				local liste   V
				foreach x of local liste {
					local liste2 G E L M
					foreach y of local liste2 {
						replace rfin_pv_fin_irpp_foy=rfin_pv_fin_irpp_foy+Z3`x'`y'
					}
					local liste2  F H
					foreach y of local liste2 {
						replace rfin_mv_fin_irpp_foy=rfin_mv_fin_irpp_foy+Z3`x'`y'
					}
				}
				
			* Stock options :
				replace rfin_pv_options_foy=rfin_pv_options_foy+Z3VJ + Z3VK+ Z3VI
				local liste   T U
				foreach x of local liste {
					local liste2  V W X Y Z
					foreach y of local liste2 {
						replace rfin_pv_options_foy=rfin_pv_options_foy+Z1`x'`y'
					}
				}
			
			gen rfin_pv_irpp_foy=rfin_pv_fin_irpp_foy+rfin_pv_fon_irpp_foy+rfin_pv_pro_irpp_foy+rfin_pv_options_foy
			gen rfin_mv_irpp_foy=rfin_mv_fin_irpp_foy+rfin_mv_pro_irpp_foy
			drop  Z3* Z1*
	
*******************************************
* VI) Variables synthtiques de revenus
*******************************************
		/*
		gen rbg_irpp_foy=rbg
		gen rng_irpp_foy=rng
		gen rimp_irpp_foy=rni
		gen rimppv_irpp_foy=ripv
		gen rfr_irpp_foy=revkire	
		* Deficits globaux antrieurs
		gen defglo_ant_foy=Z6FA+ Z6FB+ Z6FC + Z6FD + Z6FE
		drop Z6*
		
		
	/* Rappel: avriable synthtique
	rbg : revenu brut global
	rng: revenu net global = rbg- charges dductibles
	rni: revenu net imposable = rbg-charges dductibles - abattement (ex: pers.age...)
	ripp: revenu imposable par part
	ripv : revenu imposable avec pv
	rippv: revenu imposable par part avec PV
	revkire: revenu th avec ficheir pote = revenu fiscal de reference
	*/
		*/
		
		
***************************************************************************************
	keep year pondn-rfin_mv_irpp_foy
		drop micro* 
		gen idfoy=_n
		#delimit;
			order year idfoy pondn ndecl  age agec sexe mat  npac  anaispac* 
			salchom* sal* chom* pens* rente* nonsal* nonsal_irpp* defnonsal_irpp* nonsalexo_irpp* rfon* 
			rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy rfin_int_irpp_foy2 rfin_int_bar_irpp_foy rfin_int_bar_irpp_foy2 rfin_int_pl_irpp_foy rfin_div_irpp_foy rfin_div_irpp_foy2 rfin_div_bar_irpp_foy rfin_div_bar_irpp_foy2 rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
			rfin_pv_irpp_foy rfin_pv_pro_irpp_foy rfin_pv_fon_irpp_foy rfin_pv_fin_irpp_foy rfin_pv_options_foy rfin_mv_irpp_foy rfin_mv_pro_irpp_foy  rfin_mv_fin_irpp_foy ;
			#delimit cr
		save "$wfrev/rev${year}.dta",replace
		
		
		
		
